/*  play a simple video
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video/
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.video.*; 

// Step 1. Declare a Movie object.
Movie movie; 

void setup() {  
  size(320, 240);  

  // Step 2. Initialize Movie object. The file "testmovie.mov" should live in the data folder.
  movie = new Movie(this, "countdown.mov");  

  // Step 3. Start playing movie. To play just once play() can be used instead.
  movie.loop();
  // movie.play();
}

// Step 4. Read new frames from the movie.
void movieEvent(Movie m) {  
  m.read();
}

// Step 5. Display movie.
void draw() {
  image(movie, 0, 0);
}

/*
   From the movieEvent Help file in Processing:
   
   This event function is run when a new movie frame is available. 
   Use the read() method to capture this frame. If there is more than one movie in the program, 
   movieEvent() is called each time any of the movies has a new frame available. Use an if to 
   determine which movie is triggering the event. See the above example for implementation details.

   This function is for people who want to process the image data separately from drawing 
   (and as quickly as possible.) You cannot draw to the screen inside the movieEvent() function. 
   If you want to draw immediately based on the new image, then use the Movie.available() method. 
*/